function tanimoto(obj,varargin)
%TANIMOTO  Calculate similarity method using Tanimoto coefficient
%Note: This is slightly different from the method used in calculating the
%Tanimoto coefficient in the link communities algorithm

aMat = rmSelfEdges(obj.adjMat);


if ~isempty(obj.groups)
    
    outMat = combineCells(aMat,{},obj.groups);
    inMat = combineCells(aMat,obj.groups,{});
    [Aout outRowLabs outColLabs] = getMatrix(outMat);
    [Ain inRowLabs inColLabs] = getMatrix(inMat);
    switch obj.direction
        case 'outgoing'
            num = Aout*Aout';
            obj.Slabels = outRowLabs;
        case 'incoming'
            num = Ain'*Ain;
            obj.Slabels = inRowLabs;
        case 'both'
            num = AdjacencyMatrix(Aout*Aout',outRowLabs,outRowLabs) + AdjacencyMatrix(Ain'*Ain,inColLabs,inColLabs);
            [num obj.Slabels] = getSquareMatrix(num);
    end
    
    
else
    switch obj.direction
        case 'outgoing'
            [A obj.Slabels tmp] = getMatrix(aMat);
            num = A*A';
        case 'incoming'
            [A tmp obj.Slabels] = getMatrix(aMat);
            num = A'*A;
        case 'both'
            [A obj.Slabels] = getSquareMatrix(aMat);
            num = A*A' + A'*A;
    end

end
N = size(num,1);

denom = repmat(diag(num)',[N 1]) + repmat(diag(num),[1 N]) - num;


obj.S = num./denom;

end

